{!! Form::open(null, ['class' => 'col-md-12']) !!}
<table class="table table-striped table-condensed">
	<thead>
	<tr style="font-weight: bold">
		<td>
			<span class="glyphicon glyphicon-check"></span>
		</td>
		<td>Login</td>
		<td>Role</td>
        @if (Helper::checkActionInRole('See user net list'))
			<td>Net List</td>
        @endif
		@if (Helper::checkActionInRole('Edit user country list'))
			<td>Country List</td>
		@endif
		<td></td>
	</tr>
	</thead>
	<tbody>
	@foreach($users as $user)
		<tr>
			<td>
				<input type="checkbox" name="check[]" value="{{ $user->id }}">
			</td>
			<td>
				{{ $user->username }}
			</td>
			<td>
				<ul>
					@foreach($user->roles->find_all() as $role)
						@if($role->id != '1')
							<li>
								{{ $role->name }}
							</li>
						@endif
					@endforeach
				</ul>
			</td>
			@if (Helper::checkActionInRole('See user net list'))
				<td>
					@if($file_path = Kohana::find_file('net_access', $user->id, 'json'))
						<ul style="margin-bottom: 0">
							@foreach(json_decode(file_get_contents($file_path)) as $net)
							<li>{{ $net }}</li>
							@endforeach
						</ul>
					@else
						<ul style="margin-bottom: 0">
							<li>All</li>
						</ul>
					@endif
				</td>
			@endif
			@if (Helper::checkActionInRole('Edit user country list'))
				<td>
					@if($file_path = Kohana::find_file('country_access', $user->id, 'json'))
						<ul style="margin-bottom: 0">
							@foreach(json_decode(file_get_contents($file_path)) as $net)
								<li>{{ $net }}</li>
							@endforeach
						</ul>
					@else
						<ul style="margin-bottom: 0">
							<li>All</li>
						</ul>
					@endif
				</td>
			@endif
			<td>
				<a class="btn btn-primary pull-right btn-xs" href="/users/editor/{{ $user->id }}" style="margin-right: 10px;">
					<span class="glyphicon glyphicon-edit"></span>
				</a>
				@if(Helper::checkActionInRole('View user filter list'))
                    <a href="{{ $user->id != Auth::instance()->get_user()->id ? "/users/view_user_queries/".$user->id : "/myqueries/" }}" class="btn btn-xs btn-primary pull-right {{ !$user->queries->find()->loaded() ? 'disabled' : ''}}" style="margin-right: 10px;">
						FilterList
					</a>
				@endif
				@if(Helper::checkActionInRole('Edit user net list'))
					<a href="/users/edit_net_access/{{ $user->id }}" class="btn btn-xs btn-primary pull-right" style="margin-right: 10px;">
						NetList
					</a>
				@endif
				@if(Helper::checkActionInRole('Edit user country list'))
					<a href="/users/edit_country_access/{{ $user->id }}" class="btn btn-xs btn-primary pull-right" style="margin-right: 10px;">
						CountryList
					</a>
				@endif
                @if ( Helper::checkActionInRole('ActiveSessionsAndLastLogins') )
					<a class="btn btn-xs btn-primary pull-right" style="margin-right: 10px;" href="/users/lastlogins/{{ $user->id }}">
						Last logins
					</a>
					<a class="btn btn-xs btn-primary pull-right" style="margin-right: 10px;" href="/users/activesessions/{{ $user->id }}">
						Active sessions
					</a>
                @endif
			</td>
		</tr>
	@endforeach
	</tbody>
	<tfoot>
	<tr>
		@if(Helper::checkActionInRole('See user net list') && Helper::checkActionInRole('Edit user country list'))
			<td colspan="6">
		@elseif(Helper::checkActionInRole('See user net list') || Helper::checkActionInRole('Edit user country list'))
			<td colspan="5">
		@else
			<td colspan="4">
		@endif
			<input type="checkbox" id="select_all">
			<div class="btn-group btn-group-sm pull-right">

					{!! Form::button('del', '<span class="glyphicon glyphicon-trash"></span>', [
						'class' => 'btn btn-xs btn-danger',
						'type' => 'submit',
					]) !!}

				<a href="/users/editor/" class="btn btn-success">
					<span class="glyphicon glyphicon-plus"></span>
				</a>
			</div>
		</td>
	</tr>
	</tfoot>
</table>
{!! Form::close() !!}

<script>
	$('#select_all').click(function(event){
		if(this.checked) {
			$(':checkbox').each(function() {
				this.checked = true;
			});
		}else{
			$(':checkbox').each(function(){
				this.checked = false;
			});
		}
	});
</script>